# ZSLA

# Installation
## enviroment setting

```
Install anaconda and then create a enviroment, whose name is ZSLA (set in the first line of yaml file)
```bash
conda env create -f environment.yml
```
Activate the environment ZSLA
```bash
conda activate ZSLA
```
## prepare data 
1. Download the images form [CUB](http://www.vision.caltech.edu/visipedia/CUB-200-2011.html) website and unzip.
2. Modify the root path to where you place the CUB dataset in "generate_CUB_data.py".
3. Execute "generate_CUB_data.py" to generate the necessary pickle file (pre-extracted features):
```bash
python generate_CUB_data.py
```
## run

### run ZSLA
Their are two stages in ZSLA, the first stage is to obtain the seen attribute directors and the second stage is to train intersection/union models and use them to syntheize the unseen attribute directors.
Here we use CUB dataset as example:
#### stage 1  
train: 
```bash
python main.py --device=cuda:5 --stage=1 --is_normalized --is_abs --use_location_info --cpt_weight=0.2 --umc_start=0  --output_PATH=./outputs/stage1_cub
```
test: 
```bash
python main.py --test --device=cuda:5 --stage=1  --is_normalized --is_abs --attributes_PATH=./outputs/stage1_cub/classifier_10000.pth
```
#### stage 2
train: 
```bash
python main.py --device=cuda:5 --stage=2 --is_normalized --is_abs --attributes_PATH=./outputs/stage1_cub/classifier_10000.pth --output_PATH=./outputs/stage2_cub
```

test: 
```bash
python main.py --test --device=cuda:5 --stage=2 --gate_PATH=./outputs/stage2_cub/model_200000.pth
```
### run baseline
#### A-ESZSL
train: 
```bash
python main.py --baseline --method=A-ESZSL --device=cuda:5 --use_location_info --output_PATH=./outputs/A_ESZSL_cub 
```
test: 
```bash
python main.py --test --baseline --method=A-ESZSL --device=cuda:5 --use_location_info --baseline_PATH=./outputs/A_ESZSL_cub/model_5000.pth
```
#### A-LAGO
train: 
```bash
python main.py --baseline --method=A-LAGO --device=cuda:5 --use_location_info --output_PATH=./outputs/A_LAGO_cub 
```
test: 
```bash
python main.py --test --baseline --method=A-LAGO --device=cuda:5 --use_location_info --baseline_PATH=./outputs/A_LAGO_cub/model_5000.pth
```

